using System;
using Server;
using Server.Items;
using Server.Network;

namespace Server.Gumps
{
	public class CreditDepositGump : Gump
	{
		private CreditCard ccParent;
		
		public CreditDepositGump( CreditCard from ) : base( 0, 0 )
		{
			this.Closable=true;
			this.Disposable=true;
			this.Dragable=true;
			this.Resizable=false;
			
			this.AddPage(0);
			this.AddBackground(246, 141, 250, 157, 2600);
			this.AddLabel(309, 160, 0, @"UO Credit Card");
			this.AddLabel(270, 190, 0, @"Enter the amount to deposit:");
			this.AddImage(285, 210, 2440);
			this.AddButton(300, 240, 247, 248, 1, GumpButtonType.Reply, 0);
			this.AddButton(380, 240, 241, 242, 0, GumpButtonType.Reply, 0);
			this.AddTextEntry(294, 213, 145, 15, 0, 0, @"0");
			
			ccParent = from;
		}
		
		public override void OnResponse( NetState state, RelayInfo info )
		{
			Mobile m_from = state.Mobile;
			int depositAmount = Int32.Parse( info.GetTextEntry( 0 ).Text );
			int difference = ccParent.UsedCredit - depositAmount;
			int adjustedAmount = depositAmount + difference;
			int balance;
			
			if ( info.ButtonID == 1 )
			{
				if ( depositAmount <= 0 )
				{
					m_from.SendMessage("You did not enter an amount to deposit.");
					m_from.SendGump( new CreditDepositGump( ccParent ) );
					return;
				}
				
				if ( difference >= 0 )
				{
					if ( m_from.Backpack.ConsumeTotal( typeof( Gold ), depositAmount ) )
					{
						ccParent.UsedCredit = ccParent.UsedCredit - depositAmount;
						balance = ccParent.CreditLimit - ccParent.UsedCredit;
						ccParent.Name = "Credit Card: " + balance;
						m_from.SendMessage("{0} Gold Deposited", depositAmount);
					}
					else
						if ( m_from.BankBox.ConsumeTotal( typeof( Gold ), depositAmount ) )
						{
							ccParent.UsedCredit = ccParent.UsedCredit - depositAmount;
							balance = ccParent.CreditLimit - ccParent.UsedCredit;
							ccParent.Name = "Credit Card: " + balance;
							m_from.SendMessage("{0} Gold Deposited", depositAmount);
						}
						else
						{
							m_from.SendMessage("You do not have enough gold.");
						}
				}
				else
				{
					m_from.SendMessage("Deposit amount adjusted to {0}", adjustedAmount);
					
					if ( m_from.Backpack.ConsumeTotal( typeof( Gold ), adjustedAmount ) )
					{
						ccParent.UsedCredit = ccParent.UsedCredit - adjustedAmount;
						balance = ccParent.CreditLimit - ccParent.UsedCredit;
						ccParent.Name = "Credit Card: " + balance;
						m_from.SendMessage("{0} Gold Deposited", adjustedAmount);
					}
					else
						if ( m_from.BankBox.ConsumeTotal( typeof( Gold ), adjustedAmount ) )
						{
							ccParent.UsedCredit = ccParent.UsedCredit - adjustedAmount;
							balance = ccParent.CreditLimit - ccParent.UsedCredit;
							ccParent.Name = "Credit Card: " + balance;
							m_from.SendMessage("{0} Gold Deposited", adjustedAmount);
						}
						else
						{
							m_from.SendMessage("You do not have enough gold.");
						}
				}
			}
			else
				m_from.SendGump( new CreditCardGump( ccParent ) );
		}
	}
}
