using System;
using Server;
using Server.Items;
using Server.Network;

namespace Server.Gumps
{
	public class CreditCardGump : Gump
	{
		private CreditCard ccParent;
		
		public CreditCardGump( CreditCard from ) : base( 0, 0 )
		{
			this.Closable=true;
			this.Disposable=true;
			this.Dragable=true;
			this.Resizable=false;
			
			this.AddPage(0);
			this.AddBackground(161, 120, 209, 137, 2600);
			this.AddButton(215, 170, 2117, 2118, 1, GumpButtonType.Reply, 0);
			this.AddButton(215, 195, 2117, 2118, 2, GumpButtonType.Reply, 0);
			this.AddLabel(240, 195, 0, @"Deposit");
			this.AddLabel(240, 170, 0, @"Withdraw");
			this.AddLabel(210, 142, 0, @"UO Credit Card");
			
			ccParent = from;
		}
		
		public override void OnResponse( NetState state, RelayInfo info )
		{
			if ( info.ButtonID == 1 )
				state.Mobile.SendGump( new CreditWithdrawGump( ccParent ) );
			else
				if ( info.ButtonID == 2 )
					state.Mobile.SendGump( new CreditDepositGump( ccParent ) );
		}
	}
}
