using System;
using Server.Network;
using Server.Gumps;

namespace Server.Items
{
	[Flipable( 0x12AB, 0x12AC )]
	public class CreditCard : Item
	{
		private int maxCredit = 2000;
		private int usedCredit = 0;
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int CreditLimit
		{
			get{ return maxCredit; }
			set{ maxCredit = value; }
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int UsedCredit
		{
			get{ return usedCredit; }
			set{ usedCredit = value; }
		}
		
		[Constructable]
		public CreditCard() : base( 0x12AB )
		{
			Weight = 1.0;
			Name = "Credit Card: 2000";
			LootType = LootType.Blessed;
		}
		
		[Constructable]
		public CreditCard( int amount ) : base( 0x12AB )
		{
			Weight = 1.0;
			Name = "Credit Card: " + amount;
			LootType = LootType.Blessed;
			maxCredit = amount;
		}
		
		public override void OnDoubleClick( Mobile from )
		{
			if ( IsChildOf( from.Backpack ) || IsChildOf( from.BankBox ) )
			{
				from.SendGump( new CreditCardGump( this ) );
			}
			else
				from.SendMessage("This must be in your backpack or bank to use.");
		}

		public CreditCard( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
			
			writer.Write( maxCredit );
			writer.Write( usedCredit );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
			
			maxCredit = reader.ReadInt();
			usedCredit = reader.ReadInt();
		}
	}
}
