//////////////////////////////////////////////////$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
////==========================================////$                                 $
////        Upgraded By: Triple               ////$   Will like to thank for all    $
////==========================================////$   who help me with this upgrade!$
//////////////////////////////////////////////////$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

using System;
using System.Collections; 
using Server;
using Server.Items;
using Server.Mobiles;
using Server.Gumps;
using Server.Network;
using Server.Targeting;


namespace Server.Commands
{ 
	public class KPSystem
	{ 

		public static void Initialize()
		{
			CommandSystem.Register( "KP", AccessLevel.Player, new CommandEventHandler( KP_OnCommand ) );    
		} 

		public static void KP_OnCommand( CommandEventArgs e )
		{ 
			PlayerMobile from = e.Mobile as PlayerMobile; 
          
			if( from != null ) 
			{  
				from.Target = new InternalTarget( from );
			} 
		} 

		private class InternalTarget : Target
		{
			public InternalTarget( Mobile from ) : base( 8, false, TargetFlags.None )
			{
				from.SendMessage ( "Target an animal that you own to get their kill point amount." );
			}

			protected override void OnTarget( Mobile from, object obj )
			{
				if ( !from.Alive )
				{
					from.SendMessage( "You may not do that while dead." );
				}
                           	else if ( obj is EvolutionDragon && obj is BaseCreature )
                           	{ 
					BaseCreature bc = (BaseCreature)obj;
					EvolutionDragon ed = (EvolutionDragon)obj;

					if ( ed.Controlled == true && ed.ControlMaster == from )
					{
						ed.PublicOverheadMessage( MessageType.Regular, ed.SpeechHue, true, ed.Name +" has "+ ed.KP +" kill points.", false );
					}
					else
					{
						from.SendMessage( "You do not control this dragon!" );
					}
				}
				else if ( obj is EvolutionHiryu && obj is BaseCreature ) 
				{
					BaseCreature bc = (BaseCreature)obj;
					EvolutionHiryu eh = (EvolutionHiryu)obj;

					if ( eh.Controlled == true && eh.ControlMaster == from )
					{
						eh.PublicOverheadMessage( MessageType.Regular, eh.SpeechHue, true, eh.Name +" has "+ eh.KP +" kill points.", false );
					}
					else
					{
						from.SendMessage( "You do not control this hiryu!" );
					}
                           	} 
                           	else if ( obj is EvoMerc && obj is BaseCreature ) 
                           	{ 
					BaseCreature bc = (BaseCreature)obj;
					EvoMerc em = (EvoMerc)obj;

					if ( em.Controlled == true && em.ControlMaster == from )
					{
						em.PublicOverheadMessage( MessageType.Regular, em.SpeechHue, true, em.Name +" has "+ em.KP +" kill points.", false );
					}
					else
					{
						from.SendMessage( "You do not control this mercenary!" );
					}
                           	} 
                           	else 
                           	{ 
                              		from.SendMessage( "That is not an evolution animal!" );
			   	}
			}
		}
	} 
} 
